/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.lpar;

import com.ibm.hsc.auiml.databeans.lpar.HSCDProcessorBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.websm.cec.ProcRecoverDialog;
import com.ibm.hsc.websm.cec.ResRecoverDialog;
import com.ibm.ui.framework.ValueDescriptor;
import com.ibm.websm.diagnostics.IDebug;
import java.util.Hashtable;

public class HSCDProcessorBeanExt
extends HSCDProcessorBean {
    public static final String ERR_NO_CPU_MOVE_DEST = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_NO_CPU_MOVE_DEST", "HMCERRV3DLPAR006: No destination LPAR is selected for rocessor move operation.");
    public static final String ERR_NO_CPU_SEL = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_NO_CPU_SEL", "HMCERRV3DLPAR007: The number of processor selected for DLPAR operation is equal to less than 0.");
    private int mMoveNum = 0;

    public HSCDProcessorBeanExt() {
        this.mMainPanelName = "CpuMainPanel";
        this.mAddPanelName = "CpuAddPanel";
        this.mRemovePanelName = "CpuRemovePanel";
        this.mMovePanelName = "CpuMovePanel";
        this.mTaskGroupName = "CpuTaskGroup";
        this.mAddButtonName = "CpuAddButton";
        this.mRemoveButtonName = "CpuRemoveButton";
        this.mMoveButtonName = "CpuMoveButton";
        this.mAuimlClassName = "com.ibm.hsc.auiml.databeans.lpar.DProcessor";
        this.mMoveDestName = this.mMovePanelName + ".destLpar";
    }

    public void load() {
        this.loadBackendData();
        this.m_dRemoveCpu = 0.0;
        this.m_dAddCpu = 0.0;
        this.m_dMoveAmnt = 0.0;
        this.m_dDetail = 0.0;
        this.m_cdDetail = new ValueDescriptor[0];
        this.m_cdTimeout = new ValueDescriptor[0];
        this.m_dTimeout = 1.0;
        this.m_sDetailLevel = "";
        this.m_cdDetailLevel = new ValueDescriptor[0];
    }

    private void loadBackendData() {
        try {
            Hashtable hashtable = this.loadDataFromServer("getDLPARProcessorData");
            if (hashtable == null) {
                return;
            }
            short s = (Short)hashtable.get("maxCpus");
            short s2 = (Short)hashtable.get("minCpus");
            short s3 = (Short)hashtable.get("allocCpus");
            short s4 = (Short)hashtable.get("freeCpus");
            if (s3 <= s2) {
                this.mDisableMove = true;
                this.mDisableRemove = true;
            }
            if (s3 >= s || s4 == 0) {
                this.mDisableAdd = true;
            }
            this.mRemoveNum = s3 - s2;
            if (this.mRemoveNum < 0) {
                this.mRemoveNum = 0;
            }
            this.mAddNum = s - s3;
            if (this.mAddNum > s4) {
                this.mAddNum = s4;
            }
            if (this.mAddNum < 0) {
                this.mAddNum = 0;
            }
            this.setFreeCpus("" + s4);
            this.setMaxCpu("" + s);
            this.setSourceUsage("" + s3);
            this.m_cdMoveTo = this.initMoveToData(hashtable);
            if (this.m_cdMoveTo.length == 0) {
                this.setDestUsage("");
                this.setDestMax("");
            }
            this.setDefTimeout();
            this.mRecoverData = this.buildRecoverData("getCpuRecoverInfo");
            if (IDebug.enabled) {
                System.out.println("mRecoverData is null: " + (this.mRecoverData == null));
            }
            this.setAddDisable();
        }
        catch (Throwable throwable) {
            this.mLoadException = throwable;
            this.handleException(throwable);
        }
    }

    public String getMoveDest() {
        return this.getMoveTo();
    }

    public void destChangedTo(int n) {
        this.mMoveNum = 0;
        if (this.m_cdMoveTo.length > 0) {
            int n2 = ((Short)this.mAllNums.elementAt(n)).intValue();
            int n3 = ((Short)this.mMaxNums.elementAt(n)).intValue();
            this.setDestUsage("" + n2);
            this.setDestMax("" + n3);
            this.mMoveNum = n3 - n2;
            if (this.mMoveNum > this.mRemoveNum) {
                this.mMoveNum = this.mRemoveNum;
            }
            this.setMoveTo((String)this.mUsrNames.elementAt(n));
        }
        this.mUsrTaskMgr.setAttribute(this.mMovePanelName + ".moveSpinner", 29, "" + this.mMoveNum);
    }

    protected boolean saveChanges() throws Exception {
        String[] stringArray = this.getTaskGroupSelection();
        String string = null;
        String string2 = "moveCpu";
        int n = 3;
        Integer n2 = null;
        if (IDebug.enabled) {
            System.out.println("task[0]: " + stringArray[0]);
        }
        if (stringArray[0].equals(this.mAddButtonName)) {
            n2 = new Integer((int)this.getAddCpu());
            if (n2 > this.mAddNum) {
                String string3 = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_MAX_CPU_ADD", "HMCERRV4DLPAR025: You have attempted to add {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + n2, "" + this.mAddNum});
                this.showInfo(string3, null, null);
                return false;
            }
            string2 = "addCpu";
        } else if (stringArray[0].equals(this.mRemoveButtonName)) {
            n2 = new Integer((int)this.getRemoveCpu());
            if (n2 > this.mRemoveNum) {
                String string4 = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_MAX_CPU_REMOVE", "HMCERRV4DLPAR026: You have attempted to remove {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + n2, "" + this.mRemoveNum});
                this.showInfo(string4, null, null);
                return false;
            }
            string2 = "removeCpu";
        } else if (stringArray[0].equals(this.mMoveButtonName)) {
            n2 = new Integer((int)this.getMoveAmnt());
            ++n;
            string = this.getMoveTo();
            if (string == null) {
                this.showInfo(ERR_NO_CPU_MOVE_DEST, null, null);
                return false;
            }
            if (n2 > this.mMoveNum) {
                String string5 = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_MAX_CPU_MOVE", "HMCERRV4DLPAR027: You have attempted to move {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + n2, "" + this.mMoveNum});
                this.showInfo(string5, null, null);
                return false;
            }
            string = (String)this.mIntNames.elementAt(this.mUsrNames.indexOf(string));
        } else {
            return false;
        }
        if (n2 <= 0) {
            this.showInfo(ERR_NO_CPU_SEL, null, null);
            return false;
        }
        short s = (short)this.getDetail();
        int n3 = (int)this.getTimeout();
        Object[] objectArray = new Object[n];
        int n4 = 0;
        objectArray[n4++] = n2;
        if (string != null) {
            objectArray[n4++] = string;
        }
        objectArray[n4++] = new Integer(n3);
        objectArray[n4++] = new Short(s);
        this.saveDataToServer(string2, objectArray, s <= 0);
        return true;
    }

    public void setDynamicValues() {
        super.setDynamicValues();
        String string = this.mUsrTaskMgr.getCaptionText(this.mMainPanelName);
        this.mUsrTaskMgr.setCaptionText(this.mMainPanelName, string + " " + this.mUserDefinedName);
        this.mUsrTaskMgr.setAttribute(this.mRemovePanelName + ".removeSpinner", 29, "" + this.mRemoveNum);
        this.mUsrTaskMgr.setAttribute(this.mAddPanelName + ".addSpinner", 29, "" + this.mAddNum);
        this.destChangedTo(0);
        if (!this.mDisableAdd && this.mDisableAddControls) {
            this.mUsrTaskMgr.setEnabled(this.mAddPanelName + ".addSpinner", false);
        }
        if (IDebug.enabled) {
            System.out.println("mRecoverData: " + this.mRecoverData);
            System.out.println("mDisableAdd: " + this.mDisableAdd);
        }
        if (!this.mDisableAdd && this.mRecoverData == null) {
            this.mUsrTaskMgr.setEnabled(this.mAddPanelName + ".ProcInfoBtn", false);
        }
        this.mUsrTaskMgr.refreshAllElements();
    }

    public ResRecoverDialog getRecoverDialogInst() {
        return ProcRecoverDialog.getInstance();
    }
}

